*Add the sample design variables to the cross-sectional files
*Tim Goedemé, 10/07/2020

/*
Note: this do-file makes use of the Stata do-files to add the pseudo 
sample design variables to the datafile, which are available at my homepage.
The reasons for doing so, and the do-files themselves can be downloaded from: 
https://timgoedeme.com/eu-silc-standard-errors/

Download these do-files, and adjust the directories in them so they contain the 
information about where to extract and store the EU-SILC data.
Subsequently, you can run this do file, which will call each of these 'sample 
design variable' do-files .


Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. 
This file can be changed and re-shared for non-commercial use, as long as our original work 
is recognised and the revised work is made available under the same conditions.

When using this do-file, please cite as:
Goedemé, T., Nolan, B., Paskov, M., & Weisstanner, D. (2021). 
Occupational Social Class and Earnings Inequality in Europe: A Comparative Assessment. 
In: Social Indicators Research. DOI: https://doi.org/10.1007/s11205-021-02746-z; https://timgoedeme.com/tools/esec-in-eu-silc/

*/



global place1 <<directory with data>>
global countries1 AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK

global place2 <<directory of where you would like to save output>>
global exelfile Svyset_allyears1.xls

*Append d-files by year, run do-file to add sample design variables, save files by country

forvalues year=2004/2018 {
    di "********************"
	di "*     `year'     *"
	di "********************"
	clear
	foreach ctry of global countries1 { // append the files by year
		cap confirm file "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'D.dta"
		if _rc==0 {
			di "`ctry'", _continue
			append using "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'D.dta", force
			cap drop lastup
			cap drop lasttime
			
	    }
	}
	
	do "...\SvysetEUSILC_`year'.do"
	
	foreach var of varlist _all {
		local newname = lower("`var'")
		cap rename `var' `newname'
	}
	compress

	preserve
	foreach ctry of global countries1 {
		cap confirm file "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'D.dta"
		if _rc==0 {
			cap restore, preserve
			keep if country=="`ctry'"
			save "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'D_sd.dta", replace
		}
	}
	restore
	
}

*


